<?php

namespace JinoAntony\Kanban\Commands;

use Illuminate\Support\Str;
use Illuminate\Console\GeneratorCommand;

class KanbanMakeCommand extends GeneratorCommand
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'kanban:make {name : The name of the Kanban Board.}';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Create a new Kanban class.';

    /**
     * The type of class being generated.
     *
     * @var string
     */
    protected $type = 'Kanban Board';

    /**
     * Parse the name and format according to the root namespace.
     *
     * @param string $name
     * @return string
     */
    protected function qualifyClass($name)
    {
        $rootNamespace = $this->laravel->getNamespace();

        if (Str::startsWith($name, $rootNamespace)) {
            return $name;
        }

        if (Str::contains($name, '/')) {
            $name = str_replace('/', '\\', $name);
        }

        if (!Str::contains(Str::lower($name), 'kanban')) {
            $name .= 'Kanban';
        }

        return $this->getDefaultNamespace(trim($rootNamespace, '\\')) . '\\' . $name;
    }

    /**
     * Get the default namespace for the class.
     *
     * @param string $rootNamespace
     * @return string
     */
    protected function getDefaultNamespace($rootNamespace)
    {
        return $rootNamespace . '\\' . 'Kanban';
    }

    /**
     * Get the stub file for the generator.
     *
     * @return string
     */
    protected function getStub()
    {
        return __DIR__ . '/stubs/kanban.stub';
    }
}
